from django.test import TestCase
from django.db import models

from bar.models import Foo, Bar


class BugRecreateTest(TestCase):
    def test_recreate_bug(self):
        qs1 = Foo.objects.all().annotate(
            _count=models.Sum('bar__count')
        ).values('name').annotate(
            total_count=models.F('_count')
        ).values('name', 'total_count')

        qs2 = Bar.objects.all().annotate(
            name=models.F('foo__name'),
            total_count=models.Value(0, output_field=models.IntegerField())
        ).values('name', 'total_count')

        self.assertEqual(list(qs1.union(qs2, all=True)), [])
        self.assertEqual(qs1.union(qs2, all=True).count(), 0)
