from django.test import TestCase
from django.db.models import Value, IntegerField, DateTimeField
from bugreport.models import Leaf, Branch


class TreeTest(TestCase):

    def test_repro(self):
        column_names = ['size', 'created_date']
        #column_names = ['created_date', 'size']  # this one works...

        leaf = Leaf.objects.create()

        branch_qs = Branch.objects.all()
        branch_qs = (
            branch_qs
            .annotate(
                size=Value(1, output_field=IntegerField()),
                created_date=Value(None, output_field=DateTimeField()),
            ).values_list(*column_names))

        leaf_qs = Leaf.objects.all()
        leaf_qs = (
            leaf_qs
            .annotate(size=Value(2, output_field=IntegerField()))
            .values_list(*column_names)
        )
        print("this works", list(leaf_qs))
        print("this fails", list(branch_qs.union(leaf_qs)))
