from django.db import models

# Create your models here.

class Question(models.Model):
    question_text = models.CharField(max_length=200)
    pub_date = models.DateTimeField("date published")


class Choice(models.Model):
    question = models.ForeignKey(Question, on_delete=models.CASCADE)
    choice_text = models.CharField(max_length=200)
    votes = models.IntegerField(default=0)
    arbitrary_num = models.IntegerField(default=0)


class Comment(models.Model):
    text = models.CharField(max_length=50)
    choice = models.ForeignKey(Choice, on_delete=models.CASCADE)


#select * 
#from choice
#where id in (
#select distinct coalesce(...) from comment left outer join choice on comment.choice_id = choice.id group by 
#
#
#select *
#from question
#where id in (select distinct coalesce(U1.qid, -1) from comment left outer join choice



'''
from django.db.models.functions import Coalesce
from django.db.models import Count, F
from polls.models import Comment, Choice, Question
inner_qs = Comment.objects.all().annotate(question_id=Coalesce(F('choice__question__id'), -1)).values('question_id').annotate(counts=Count('*'))
'''

