import django
django.setup()

from django.db.models.functions import Coalesce
from django.db.models import Count, F, Sum
from polls.models import Comment, Choice, Question

inner_qs = (
    Comment.objects.annotate(question_id=F('choice__question__id'))
        .values('question_id').annotate(cnt=Count('*'))
        .values_list('question_id')
)
outer_qs = Question.objects.filter(id__in=inner_qs).all()
print(outer_qs)
