#!/usr/bin/env python
# coding:utf-8
"""
This file is part of the Ludd21 proprietary software
License
=======

Copyright (C) <2019>  <Odile Troulet-Lambert.tex@orange.fr>

this programm is proprietary software



Module purpose
==============
tests for the module fabric_elements
because of the import of app_accounts.models and Fabric Type which inherits from
django models this test module requires django to be configured.
set environment variable $TEST_MODULE_MODELS to fabric_elements so as not to load all other model modules

Implements
==========


Documentation
=============


Usage
=====


@author: Odile Troulet-Lambert
@copyright: Odile Troulet-Lambert

"""
import unittest
import os
from unittest.mock import patch
from abc import abstractmethod, ABCMeta

from django.db.models.base import ModelBase
import django.db.models as models
from django.apps.registry import Apps


class AbstractModelMeta(ABCMeta, type(models.Model)):
    """ a Django model and python abstract class"""

    def __new__(cls, name, bases, attrs, **kwargs):

        clas = super().__new__(cls, name, bases, attrs, **kwargs)
        return clas


class Test_AbstractImplementation (unittest.TestCase):

    @classmethod
    def setUpClass(cls):
        os.environ['DJANGO_SETTINGS_MODULE'] = 'djangoLudd21.settings'
        cls.patcher = patch.object(Apps, 'check_apps_ready')
        cls.patcher.start()

        class AbsImplementation (models.Model,
                                 metaclass=AbstractModelMeta):
            class Meta:
                app_label = 'fakeapp'
                abstract = True

            field1 = models.CharField(
                max_length=20)
            field2 = models.IntegerField(
                default=5)

            @staticmethod
            def change_field():
                return 10

            @abstractmethod
            def absmethod(self):
                pass

            def __init_subclass__(cls, **kwargs):
                machine = kwargs.pop('machine', None)
                if not machine:
                    raise ValueError('implementation must have a machine attribute')
                setattr(cls, 'machine', machine)
                field1 = models.CharField(
                    max_length=cls.change_field(),
                )
                ModelBase.add_to_class(cls, 'field1', field1)

        cls.absimp = AbsImplementation

    def test(self):
        class Imp (self.absimp,
                   machine='machine'):

            class Meta:
                app_label = 'fakeapp'
                abstract = False

            def absmethod(self):
                    pass

        self.assertTrue(issubclass(Imp, models.Model))
        self.assertTrue(issubclass(Imp, self.absimp))

        self.assertEqual(Imp.machine, 'machine')
        field1 = Imp._meta.get_field('field1')
        field2 = Imp._meta.get_field('field2')
        self.assertEqual(field1.max_length, 10)
        self.assertEqual(field2.default, 5)

    @classmethod
    def tearDownClass(cls):
        cls.patcher.stop()


class Test_ConcreteImplementation (unittest.TestCase):

    @classmethod
    def setUpClass(cls):
        os.environ['DJANGO_SETTINGS_MODULE'] = 'djangoLudd21.settings'
        cls.patcher = patch.object(Apps, 'check_apps_ready')
        cls.patcher.start()

        class Implementation (models.Model,
                              metaclass=AbstractModelMeta):
            class Meta:
                app_label = 'fakeapp'
                abstract = False

            field1 = models.CharField(
                max_length=20)
            field2 = models.IntegerField(
                default=5)

            @staticmethod
            def change_field():
                return 10

            @abstractmethod
            def absmethod(self):
                pass

            def __init_subclass__(cls, **kwargs):
                machine = kwargs.pop('machine', None)
                if not machine:
                    raise ValueError('implementation must have a machine attribute')
                setattr(cls, 'machine', machine)
                field1 = models.CharField(
                    max_length=cls.change_field(),
                )
                ModelBase.add_to_class(cls, 'field1', field1)

        cls.imp = Implementation

    def test(self):
        class Imp3 (self.imp,
                    machine='machine'):

            class Meta:
                app_label = 'fakeapp'

            def absmethod(self):
                    pass

        self.assertTrue(issubclass(Imp3, models.Model))
        self.assertTrue(issubclass(Imp3, self.imp))
        self.assertEqual(Imp3.machine, 'machine')
        field1 = Imp3._meta.get_field('field1')
        field2 = Imp3._meta.get_field('field2')
        self.assertEqual(field1.max_length, 10)
        self.assertEqual(field2.default, 5)

    @classmethod
    def tearDownClass(cls):
        cls.patcher.stop()


if __name__ == '__main__':
    unittest.main()























