from django.contrib.auth import get_user_model
from django.db import models
from django_tenants.models import TenantMixin, DomainMixin


User = get_user_model()


class MyModel(models.Model):
    name = models.CharField(max_length=200)
    user = models.ForeignKey(User, on_delete=models.CASCADE)


class MyMark(models.Model):
    my_model = models.ForeignKey(MyModel, on_delete=models.CASCADE)
    mark = models.PositiveSmallIntegerField()
    user = models.ForeignKey(User, on_delete=models.CASCADE)


class Client(TenantMixin):
    name = models.CharField(max_length=100)
    created_on = models.DateField(auto_now_add=True)

    # default true, schema will be automatically created and synced when it is saved
    auto_create_schema = True


class Domain(DomainMixin):
    pass
