import os
os.environ['DJANGO_SETTINGS_MODULE'] = 'settings'

from django.newforms import forms, fields, widgets
from django.newforms.extras import widgets as extrawidgets

choicedict = dict(
    a='one',
    b='two',
    c='three',
    yellow='banana',
    green='pear',
    red='apple')

groups = (
    ('letters', ('a', 'b', 'c')),
    ('colors', ('yellow', 'red', 'green')))

choices = choicedict.items()

class MyForm(forms.Form):
    linear = fields.ChoiceField(choices=choices, widget=widgets.Select)
    grouped = fields.ChoiceField(choices=choices, widget=extrawidgets.GroupedSelect(groups=groups))

f = MyForm(dict(linear='yellow', grouped='yellow'))
print f.as_ul()
