import os
from pathlib import Path

BASE_DIR = Path(__file__).resolve().parent.parent
SECRET_KEY = 'django-insecure-&lj+p40yz1yb2&l23h4nq$b5s^&-+izdjv-uzz*t!pjkrh_i&%'
DEBUG = True
ALLOWED_HOSTS = []

INSTALLED_APPS = [
    'bar',
    'django.contrib.auth',
    'django.contrib.contenttypes',
    'django.contrib.sessions',
    'django.contrib.messages',
    'django.contrib.staticfiles',
]

MIDDLEWARE = [
    'django.middleware.security.SecurityMiddleware',
    'django.contrib.sessions.middleware.SessionMiddleware',
    'django.middleware.common.CommonMiddleware',
    'django.middleware.csrf.CsrfViewMiddleware',
    'django.contrib.auth.middleware.AuthenticationMiddleware',
    'django.contrib.messages.middleware.MessageMiddleware',
    'django.middleware.clickjacking.XFrameOptionsMiddleware',
]

DATABASES = {
    'default': {
        'ENGINE': 'django.db.backends.sqlite3',
        'NAME': BASE_DIR / 'default.sqlite3',
    },
    'extra': {
        'ENGINE': 'django.db.backends.sqlite3',
        'NAME': BASE_DIR / 'extra.sqlite3',
    },
}
DEFAULT_AUTO_FIELD = 'django.db.models.BigAutoField'

LANGUAGE_CODE = 'en-us'
TIME_ZONE = 'UTC'
USE_I18N = True
USE_L10N = True
USE_TZ = True

if 'QDEBUG' in os.environ:
    # Yay monkeypatching
    from django.db.backends.sqlite3.base import DatabaseWrapper, SQLiteCursorWrapper

    DB_NAMES = {}

    def conn_wrapper(func):
        def wrapped(self, conn_params):
            print(f'\x1b[1;33mCONNECTING TO {conn_params}\x1b[0m')
            conn = func(self, conn_params)
            DB_NAMES[conn] = conn_params['database']
            return conn
        return wrapped

    def cursor_wrapper(func):
        def wrapped(self, query, params=None):
            dbname = str(DB_NAMES.get(self.connection, None))
            if 'default' in dbname:
                color = 35
            elif 'extra' in dbname:
                color = 36
            else:
                color = 33
            print(f'\x1b[1;{color}mQUERY AGAINST{dbname}: {query}\x1b[0m')
            return func(self, query, params)
        return wrapped

    DatabaseWrapper.get_new_connection = conn_wrapper(DatabaseWrapper.get_new_connection)
    SQLiteCursorWrapper.execute = cursor_wrapper(SQLiteCursorWrapper.execute)
