from django.db import migrations

# BUG: This always uses the default database, even when the migrations are
# run to set up the extra database.
def add_bar(apps, schema_editor):
    print('RunPython starts here')
    Bar = apps.get_model('bar', 'Bar')
    Bar.objects.create(name='hello')
    print('RunPython ends here')

class Migration(migrations.Migration):
    dependencies = [ ('bar', '0001_initial'), ]

    operations = [
        migrations.RunPython(add_bar, reverse_code=migrations.RunPython.noop),
    ]
