from django.db import connection
from django.db.migrations.executor import MigrationExecutor
from django.test import (
    override_settings,
)

from migrations.test_base import MigrationTestBase

class ExecutorTests(MigrationTestBase):
    
    @override_settings(
            MIGRATION_MODULES={"migrations": "migrations.test_migrations_regression_33899"},
        )
    def test_migrate_entity(self):
        executor = MigrationExecutor(connection)
        try:
            self.assertTableNotExists("migrations_entity")
            executor.migrate([("migrations", "0001_initial")])
            self.assertTableExists("migrations_entity")
            executor.loader.build_graph()
            executor.migrate([("migrations", "0002_remove_entity_url")])
            self.assertTableExists("migrations_entity")
            executor.loader.build_graph()
        finally:
            # Unmigrate everything.
            executor = MigrationExecutor(connection)
            executor.migrate([("migrations", None)])
            self.assertTableNotExists("migrations_entity")