import datetime

from django.db import models
from django.utils import timezone




class Question(models.Model):

    token = models.CharField(
        max_length=64,
        null=True,
        blank=True,
        help_text="<p>If this field is blank on saving it will trigger a Stripe "
        "credit card payment request.</p><p>Use credit card number 4242 4242 4242 4242. "
        "This should result in a token in this field and thereby prevent further "
        "requests for money.</p><p>This works in Django 3.2.9 but not later versions.",
    )
    question_text = models.CharField(max_length=200)
    pub_date = models.DateTimeField('date published')

    def __str__(self):
        return self.question_text

    def was_published_recently(self):
        return self.pub_date >= timezone.now() - datetime.timedelta(days=1)

    def calc_price(self, region=None):
        return 5.0, 0.5, "GST", 0.1


class Choice(models.Model):
    question = models.ForeignKey(Question, on_delete=models.CASCADE)
    choice_text = models.CharField(max_length=200)
    votes = models.IntegerField(default=0)

    def __str__(self):
        return self.choice_text

