"""aicis URL Configuration

The `urlpatterns` list routes URLs to views. For more information please see:
    https://docs.djangoproject.com/en/3.2/topics/http/urls/
Examples:
Function views
    1. Add an import:  from my_app import views
    2. Add a URL to urlpatterns:  path('', views.home, name='home')

Including another URLconf
    1. Import the include() function: from django.urls import include, path
    2. Add a URL to urlpatterns:  path('blog/', include('blog.urls'))

urlpatterns = [
    path('index/', views.index, name='main-view'),
    path('bio/<username>/', views.bio, name='bio'),
    path('articles/<slug:title>/', views.article, name='article-detail'),
    path('articles/<slug:title>/<int:section>/', views.section, name='article-section'),
    path('weblog/', include('blog.urls')),
    ...
]

The route argument should be a string or gettext_lazy() (see Translating URL patterns)
that contains a URL pattern. The string may contain angle brackets (like <username>
above) to capture part of the URL and send it as a keyword argument to the view. The
angle brackets may include a converter specification (like the int part of <int:section>)
which limits the characters matched and may also change the type of the variable passed
to the view. For example, <int:section> matches a string of decimal digits and converts
the value to an int. See How Django processes a request for more details.

The view argument is a view function or the result of as_view() for class-based views.
It can also be an django.urls.include().

The kwargs argument allows you to pass additional arguments to the view function or
method. See Passing extra options to view functions for an example.

See Naming URL patterns for why the name argument is useful.

"""
from django.contrib import admin
from django.urls import include, path, re_path
from polls import views


urlpatterns = [
    # path(route, view, kwargs=None, name=None)
    #re_path(r"invoice/(?P<pk>\d+)/$", views.invoice_view, name="invoice_view"),
    # no trailing slash or the payment system barfs
    re_path(r"success$", views.success_view, name="success_view"),
    # no trailing slash or the payment system barfs
    re_path(r"payment$", views.payment_view, name="payment_view"),

    path('admin/', admin.site.urls),
]
