from decimal import Decimal as dec
from django.utils.safestring import mark_safe


def collect_gateway_context(question):
    """
    This is called from the admin so it is the correct place to fetch money.

    The payment currency is determined by the region of the chemical's company HQ
    NO - AUD only thanks to Stripe
    """
    region = "au"
    price, gst, abbrev, rate = question.calc_price(region)
    currency = "AUD"
    symbol = "$"
    rnd = 2

    # our_desc and stripe_desc are common
    our_desc = "{0} fee for <strong>{1}</strong> provisioning".format(
        "Polls",
        f"{question}".capitalize()
    )
    # get rid of html and extraneous word for Stripe description
    stripe_desc = our_desc.replace("<strong>", "").replace("</strong>", "")

    total_charge = round(dec(price) + dec(gst), rnd)
    gst_comment = "no taxes included"

    if gst > 0:
        gst_comment = f"includes {symbol}{round(dec(gst), rnd)} {abbrev}"

    prepay_message = "{0} is {1}{2:,} ({3})".format(
        our_desc,
        symbol,
        total_charge,
        gst_comment.capitalize(),
    )

    # see emailed invoice on 1 October
    cents = 100
    # amount must be an integer and in cents
    context = dict()
    context["prepay_message"] = mark_safe(prepay_message)
    context["question"] = question
    context["question_id"] = question.id
    # data_... items are stripe's items
    context["data_amount"] = int(total_charge * cents)
    context["data_description"] = mark_safe(stripe_desc)
    # set the region so Stripe confirms the currency
    context["data_locale"] = region
    # set the currency here. Stripe collects it in that currency.
    context["data_currency"] = currency.lower()
    ###
    context["data_name"] = "Polls"
    context["data_key"] = get_stripe_keys()[0]
    context["test"] = "<em>Test mode</em>"
    return context

def get_stripe_keys():
    return "pk_test_51Jt4oWGqL1TCGsN0Oiomtn3IK7be3fRjl218MZCS88YJNSW5QBnfTkmJetXCTKhVpMKcIOH2vMh9koYYxkdh1PSN00ki4IHZ38", "sk_test_51Jt4oWGqL1TCGsN0zzgbdxWouZx44UYFF0J3lXopAOuJAsSBNZekgN8rcFKNMyYoEf43SLfs4YA2d2CxoZRe0wIL00gwl10qJo"

