from django.shortcuts import render
from django.http import HttpResponse
from django.template.response import TemplateResponse
from django.utils.safestring import mark_safe
from django.views.decorators.csrf import ensure_csrf_cookie
from .forms import PaymentForm
from .utils import get_stripe_keys
from .models import Question

import stripe
# latest API version is 2020-08-27. To test a more modern version set
# stripe.api_version here - this overrides their setting.
# default stripe.api_version = "2019-03-14"
# default stripe.api_version = "2019-05-16"
stripe.api_version = "2019-05-16"


class TR(TemplateResponse):
    def __init__(self, *args, **kwargs):
        """ Need a TemplateResponse with a __name__ """
        self.__name__ = str("TR")  # pragma: no cover
        super().__init__(*args, **kwargs)  # pragma: no cover


@ensure_csrf_cookie
def payment_view(request, question=None, context=None):
    """ Gateway card details fields in PaymentForm

    Trying to do too much here. The page with the [Pay] button summons Stripe
    which collects card detail and returns a token to be charged later.

    So *this* view launches a template with Stripe stuff but which has an action
    calling for another view which requires no args

    """
    receipt = None
    screen_message = ""
    screen_insert = ""
    email_message = ""
    email_msg_html = ""
    email_msg_text = ""
    cardend = ""
    payment_message = ""
    payment_insert = ""
    charge = None
    context = context or {}
    templt = "payment.html"
    if request.method == "POST":
        rnd = 2
        # data has been submitted to Stripe via Stripe js
        # Stripe submits the js form which comes back without identifying args
        form = PaymentForm(request.POST)
        if form.is_valid():
            go_back = "/admin/polls/question/"
            try:
                token = form.cleaned_data["stripeToken"]
                print(f"\n\n\n57 token = {token}\n\n\n")
                if token:
                    email = form.cleaned_data["stripeEmail"]
                    question_id = form.cleaned_data["question_id"]
                    print(f"\n\n\n61 question_id = {question_id}\n\n\n")
                    if question_id and question is None:
                        try:
                            question = Question.objects.get(id=int(question_id))
                        except Exception as err:
                            questions = Question.objects.all()
                            print(f"\n\n\n67 err = {err}\n\n\n")
                            print(f"\n\n\n68 questions = {questions}\n\n\n")
                    if question:
                        print(f"\n\n\n70 question = {question}\n\n\n")
                        region = "au"
                        # decimal, decimal, str, decimal
                        fee, gst, abbrev, rate = question.calc_price(region)
                        cents = 100
                        ###  # [1] is the secret key
                        skey = get_stripe_keys()[1]
                        print(f"\n\n\n77 skey = {skey}\n\n\n")
                        try:
                            stripe.api_key = skey
                        except Exception as err:
                            print(f"\n\n\n81 err = {err}\n\n\n")
                            raise
                        ###
                        amt = int((fee + gst) * cents)
                        print(f"\n\n\n85 amt = {amt}\n\n\n")
                        charge = stripe.Charge.create(
                            amount=amt,
                            currency="aud",
                            description=f"{question}".capitalize(),
                            source=token,
                        )
                        print(f"\n92 token = {token}")
                        if charge:
                            cardend = charge["source"]["last4"]
                            print(f"\n\n\n95 cardend = {cardend}\n\n\n")
                            go_back = f"/admin/question/question/{question.id}/"
                            question.token = token      # <<<<<<<<<---------##########
                            question.save()
                            print(f"\n\n\n99 question.token = {question.token}\n\n\n")
                            # transaction is done for all time
                            # now make a receipt --> skipped for testing
                            # which will return a skeletal page
                            return success_view(request, context)
                        else:
                            raise Exception("Gateway error")
                    else:
                        raise Exception("Question error")
                else:
                    raise Exception("No token error")
            except Exception as err:
                err = f"{err}"
                if "cannot use a Stripe token" in err:
                    backto = ""
                    if question:
                        go_back = f"/admin/question/question/{question.id}/"
                        backto = '<p><a href="{0}">Back to {1}</a>' "</p>".format(
                            go_back, f"{question}".capitalize()
                        )
                    screen_message = "<p>Cannot process the same payment twice.</p>"\
                    "<p>If an emailed receipt is not received at the address you "\
                    "specified please get in touch with <em>{0}</em> to ascertain "\
                    "whether payment was successful. Please copy and paste the token "\
                    "below as a reference.</p><p>{1}</p><p>{2}<p>".format(
                        "Polls Support",
                        token or "No token at this point (351)",
                        backto,
                    )
                else:
                    screen_message = "{0}. Please report this error message to {1}"\
                    "".format(err, "Polls Support")
                context["message"] = mark_safe(screen_message)
                form.add_error(None, f"{err}")
            return success_view(request, context)
        else:
            print(f"\n178 polls.views form invalid\n {form}")
    else:
        form = PaymentForm()
    context["form"] = form
    return TR(request=request, template=templt, context=context)


def success_view(request, context=None):
    """ launched after a Stripe token is received

    context is passed in by payment_view and has context['message']
    """
    #print(f"\n459 billing.views context {context}")
    if context is None:
        context = dict()
    context["message"] = mark_safe((
        'Payment details cannot be reproduced here but may be reviewed via the '
        'Invoice/Receipt page'
    ))
    return TR(request=request, template="success.html", context=context)

