# -*- coding: utf-8 -*-
from django.conf import settings
from django import forms

"""
All forms inherit add_error(self, field, error) where:
    field==None means NON_FIELD_ERROR
    error can be a string or an instance of an error or a list of errors
so
    self.add_error(None, ['Sorry, card was declined'])

https://docs.djangoproject.com/en/1.11/topics/forms/#looping-over-hidden-and-visible-fields
https://docs.djangoproject.com/en/1.11/ref/forms/widgets/#specifying-widgets
"""


class PaymentForm(forms.Form):
    question_id = forms.CharField(widget=forms.HiddenInput, required=False)

    stripeToken = forms.CharField(widget=forms.HiddenInput, required=False)
    stripeEmail = forms.CharField(widget=forms.HiddenInput, required=False)
    stripeBillingName = forms.CharField(widget=forms.HiddenInput, required=False)
    stripeBillingAddressLine1 = forms.CharField(
        widget=forms.HiddenInput, required=False
    )
    stripeBillingAddressZip = forms.CharField(widget=forms.HiddenInput, required=False)
    stripeBillingAddressState = forms.CharField(
        widget=forms.HiddenInput, required=False
    )
    stripeBillingAddressCity = forms.CharField(widget=forms.HiddenInput, required=False)
    stripeBillingAddressCountry = forms.CharField(
        widget=forms.HiddenInput, required=False
    )

