from django.test import TestCase
import polls

# Create your tests here.

class MyTestCase(TestCase):
  def test(self):

    # create many Reporter's for later bulk_create
    # (some Reporter's may already be saved to the DB -> see below)
    r1=polls.models.Reporter()

    # create many Article's with ForeignKey's to Reporter
    # note that the to_field is the "uuid" not the "id" (=pk) of Reporter
    # this enables bulk_create with ForeignKey
    a1=polls.models.Article()
    a1.reporter=r1

    # bulk create all Reporter's
    # -> use ignore_conflicts=True since some Reporter's may already be saved to the DB (not used in this test)
    polls.models.Reporter.objects.bulk_create([r1], ignore_conflicts=True)
    # bulk create all Article's
    # !!! This fails with django >= 3.2 !!!
    polls.models.Article.objects.bulk_create([a1])
