from django import forms
from django.contrib.auth import get_user_model
from django.forms.renderers import get_default_renderer

User = get_user_model()


class ExampleForm(forms.ModelForm):
    class Meta:
        model = User
        fields = ("username",)


class FormSet(forms.BaseModelFormSet):
    form = ExampleForm
    model = User
    min_num = 0
    absolute_max = max_num = 200
    renderer = get_default_renderer()
    extra = 1
    can_order = False
    validate_min = validate_max = can_delete = True
    can_delete_extra = False
