from django.test import TestCase
from django.urls import reverse


class ExampleTestCase(TestCase):
    def test_formset(self):
        response = self.client.post(
            reverse("default"),
            {
                "form-0-username": "test" * 50,
                "form-TOTAL_FORMS": "1",
                "form-INITIAL_FORMS": "0",
                "form-MIN_NUM_FORMS": "0",
                "form-MAX_NUM_FORMS": "1000",
            },
        )
        self.assertFormsetError(
            response,
            "form",
            0,
            "username",
            ["Ensure this value has at most 150 characters (it has 200)."],
        )
