from django.db import models
from django.contrib.auth.models import User

class GameGenre( models.Model ):
    class Admin:
        pass

    class Meta:
        ordering = ( 'sort_order', )

    def __str__( self ):
        return self.name
    
    name = models.CharField( maxlength=60)
    sort_order = models.PositiveSmallIntegerField()


class Game( models.Model ):
    class Admin:
        pass

    class Meta:
        ordering = ( 'name', )

    def __str__( self ):
        return self.name

    name = models.CharField( maxlength=60 )
    genre = models.ForeignKey( GameGenre )


class Profile( models.Model ):
    class Admin:
        pass

    def __str__( self ):
        return self.user.username
    
    user = models.ForeignKey( User, unique=True, edit_inline=models.STACKED,
                              max_num_in_admin=1, num_in_admin=1, core=True )
    description = models.TextField( blank=True)
    city = models.CharField( maxlength=30, blank=True )
    state_province = models.CharField( "State or province", maxlength=30, blank=True ) # TODO make state_province table (can't use USStateField)
    country = models.CharField( maxlength=30, blank=True ) # TODO make Country table
    zip_code = models.CharField( maxlength=10, blank=True ) # TODO need to write your own validator (see validator docs)

    genres_of_interest = models.ManyToManyField( GameGenre, blank=True )


class GameOfInterest( models.Model ):
    class Admin:
        pass

    def __str__( self ):
        return self.game.name

    game = models.ForeignKey( Game, blank=False )
    profile = models.ForeignKey( Profile, edit_inline=models.TABULAR, num_in_admin=1, core=True, blank=False )
    own = models.BooleanField()
    wish_to_play = models.BooleanField()
    willing_to_play = models.BooleanField()
