from django.http import HttpResponse
from django.db.models import Count, IntegerField, Value, Subquery, F
from django.db.models.functions import Coalesce
import sqlparse
import json
from .models import Article, Comment



def format_sql(raw):
    return sqlparse.format(str(raw), reindent=True, keyword_case='upper')


def test_view(request):
    # generate test data

    article = Article.objects.create(author_name="Jack", content="Example content", is_public=True)
    comment = Comment.objects.create(article=article, author_name="John", content="Example comment")

    # bug:

    qs = Article.objects.all()

    # keep one list_x uncommented to see the difference:
    list_x = ["random_thing_that_is_not_equal_to_any_authors_name"] # list not empty, bug doesnt occur
    #list_x = [] # if this list is empty, then the bug occurs

    comment_qs = Comment.objects.filter(author_name__in=list_x)

    qs = qs.annotate(
        A=Coalesce(Subquery(
            comment_qs.annotate(x=Count('content')).values('x')[:1], output_field=IntegerField(),
        ), 101) # if list_x == [], Coalesce wont work and A will be 0 instead of 101
    )
    # please note that above annotation doesnt make much logical sense, its just for testing purposes

    qs = qs.annotate(
        B=Value(99, output_field=IntegerField())
    )

    qs = qs.annotate(
        C=F("A") + F("B") # if list_x == [], C will result in 0 sic! instead of 101 + 99 = 200
    )

    data = {
        "A": qs.last().A,
        "B": qs.last().B,
        "C": qs.last().C,
    }

    print(data)
    print(format_sql(qs.query))

    return HttpResponse()
