from django.conf import settings
from django.contrib.auth.models import AbstractUser
from django.db import models
from django.utils.translation import gettext_lazy as _


class User(AbstractUser):
    language = models.CharField(
        _("language"),
        max_length=5,
        default=settings.LANGUAGE_CODE,
        choices=settings.LANGUAGES,
    )

    class Meta:
        verbose_name = _("user")
        verbose_name_plural = _("users")
