from django.db import models
from django.utils.translation import gettext_lazy as _


class Author(models.Model):
    first_name = models.CharField(_("first name"), max_length=255)
    last_name = models.CharField(_("last name"), max_length=255)


class Book(models.Model):
    title = models.CharField(_("title"), max_length=255)
    author = models.ForeignKey("Author", on_delete=models.PROTECT, verbose_name=_("author"))
