from collections import namedtuple

from django.utils.functional import SimpleLazyObject

import os
from django.conf import settings
import django
from django.template import Template, Context

ROOT = os.path.dirname(django.__file__)


def urls():
    from django.urls import path
    from django.contrib import admin

    return (path("admin", admin.site.urls),)


settings.configure(
    DEBUG=False,
    INSTALLED_APPS=(
        "django.contrib.contenttypes",
        "django.contrib.auth",
        "django.contrib.admin",
    ),
    ROOT_URLCONF=SimpleLazyObject(urls),
    TEMPLATES=[
        {
            "BACKEND": "django.template.backends.django.DjangoTemplates",
            "DIRS": [],
            "APP_DIRS": True,
            "OPTIONS": {
                "context_processors": [
                    "django.template.context_processors.request",
                    "django.contrib.auth.context_processors.auth",
                    "django.contrib.messages.context_processors.messages",
                ],
            },
        },
    ],
)
django.setup()


changelist_path = os.path.join(
    ROOT, "contrib", "admin", "templates", "admin", "change_list.html"
)
with open(changelist_path, "r") as f:
    changelist = f.read()

t = Template(changelist)
fakeopts = namedtuple("Opts", "app_label object_name")("auth", "user")


class ChangeList:
    result_count = 0
    full_result_count = 0
    opts = fakeopts
    list_display = ()
    formset = None
    result_list = ()
    show_all = False
    multi_page = False
    can_show_all = True

    def get_ordering_field_columns(self):
        return []


ctx = Context({"cl": ChangeList(), "opts": fakeopts})


def yappi():
    import yappi as pr

    pr.start()

    for x in range(1_000):
        t.render(ctx)

    pr.stop()
    pr.get_func_stats().print_all()


def cprofile():
    import cProfile as profiler

    pr = profiler.Profile()
    pr.enable()

    for x in range(1_000):
        t.render(ctx)

    pr.disable()
    pr.print_stats()


def timeonly():
    for x in range(1_000):
        t.render(ctx)


if __name__ == "__main__":
    # For checking walltime via CLI `time python ...`
    for x in range(1_000):
        t.render(ctx)
