# Generated by Django 3.2 on 2021-04-28 23:39

import django.contrib.postgres.fields
from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    initial = True

    dependencies = [
    ]

    operations = [
        migrations.CreateModel(
            name='Actor',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
            ],
        ),
        migrations.CreateModel(
            name='RealmAccess',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created', models.DateTimeField(auto_now_add=True)),
                ('updated', models.DateTimeField(auto_now=True)),
                ('create_by', models.JSONField(blank=True, null=True)),
                ('update_by', models.JSONField(blank=True, null=True)),
                ('name', models.CharField(max_length=100)),
            ],
            options={
                'abstract': False,
                'default_permissions': ('add', 'edit', 'delete', 'view'),
            },
        ),
        migrations.CreateModel(
            name='Thing',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created', models.DateTimeField(auto_now_add=True)),
                ('updated', models.DateTimeField(auto_now=True)),
                ('create_by', models.JSONField(blank=True, null=True)),
                ('update_by', models.JSONField(blank=True, null=True)),
                ('date', models.DateField()),
                ('average', models.DecimalField(decimal_places=8, default=0, max_digits=16)),
                ('data_points', models.IntegerField(default=0)),
                ('realms', django.contrib.postgres.fields.ArrayField(base_field=models.IntegerField(), default=list, size=None)),
                ('actor', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='thing_actor', to='things.actor')),
            ],
            options={
                'unique_together': {('realms', 'actor', 'date')},
            },
        ),
        migrations.CreateModel(
            name='ActorRealmAccess',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created', models.DateTimeField(auto_now_add=True)),
                ('updated', models.DateTimeField(auto_now=True)),
                ('create_by', models.JSONField(blank=True, null=True)),
                ('update_by', models.JSONField(blank=True, null=True)),
                ('actor', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='actor_realm_access', to='things.actor')),
                ('property_group', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='actor_realm_access', to='things.realmaccess')),
            ],
            options={
                'abstract': False,
                'default_permissions': ('add', 'edit', 'delete', 'view'),
            },
        ),
        migrations.AddField(
            model_name='actor',
            name='realm_access',
            field=models.ManyToManyField(related_name='management_agents', through='things.ActorRealmAccess', to='things.RealmAccess'),
        ),
        migrations.AddField(
            model_name='actor',
            name='thing',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='actor_thing', to='things.thing'),
        ),
    ]
