from django.contrib.postgres.fields import ArrayField
from django.db import models

# Create your models here.
from django.db import models


# SELECT COUNT(*)
# 	FROM (
# 		SELECT DISTINCT
# 			"thing_managerticketratingcumulativemovingaverage"."id" AS Col1, "thing_managerticketratingcumulativemovingaverage"."created" AS Col2, "thing_managerticketratingcumulativemovingaverage"."updated" AS Col3, "thing_managerticketratingcumulativemovingaverage"."create_by" AS Col4, "thing_managerticketratingcumulativemovingaverage"."update_by" AS Col5, "thing_managerticketratingcumulativemovingaverage"."tenant_objs" AS Col6, "thing_managerticketratingcumulativemovingaverage"."date" AS Col7, "thing_managerticketratingcumulativemovingaverage"."average" AS Col8, "thing_managerticketratingcumulativemovingaverage"."data_points" AS Col9, "thing_managerticketratingcumulativemovingaverage"."agent_id" AS Col10, COUNT("manager_managementagentpropertygroup"."property_group_id") AS "agent__property_groups__count"
# 		FROM "thing_managerticketratingcumulativemovingaverage"
# 		INNER JOIN "manager_managementagent"
# 			ON ("thing_managerticketratingcumulativemovingaverage"."agent_id" = "manager_managementagent"."id")
# 		LEFT OUTER JOIN "manager_managementagentpropertygroup"
# 			ON ("manager_managementagent"."id" = "manager_managementagentpropertygroup"."management_agent_id")
# 		LEFT OUTER JOIN "manager_managementagentpropertygroup" T5
# 			ON ("manager_managementagent"."id" = T5."management_agent_id") GROUP BY "thing_managerticketratingcumulativemovingaverage"."id", T5."property_group_id",
# 			(
# 			    -- the issue is right here
# 				SELECT U0."id", U0."created", U0."updated", U0."create_by", U0."update_by", U0."tenant_objs", U0."name"
# 				-- the issue is the line above
# 				FROM "property_propertygroup" U0
# 				INNER JOIN "manager_managementagentpropertygroup" U1
# 					ON (U0."id" = U1."property_group_id")
# 					WHERE U1."management_agent_id" = %s) HAVING (
# 						T5."property_group_id" IN (
# 							SELECT U0."id"
# 							FROM "property_propertygroup" U0
# 							INNER JOIN "manager_managementagentpropertygroup" U1
# 							ON (U0."id" = U1."property_group_id")
# 							WHERE U1."management_agent_id" = %s)
# 								OR COUNT("manager_managementagentpropertygroup"."property_group_id") = %s)
# 			);
from django.db.models import JSONField, Count, Q


class BaseModel(models.Model):
    created = models.DateTimeField(auto_now_add=True)
    updated = models.DateTimeField(auto_now=True)
    create_by = JSONField(null=True, blank=True)
    update_by = JSONField(null=True, blank=True)

    class Meta:
        abstract = True
        default_permissions = ("add", "edit", "delete", "view")

class BaseQuerySet(models.QuerySet):
    def filter_thing(self, lookup):
        filter_kwargs = {lookup: self.cur_realm}
        return self.filter(**filter_kwargs)

class AnExtraModelManager(BaseQuerySet):
    def get_or_create(self, **kwargs):
        # Need to get previous model before adding the new one
        previous_model = None
        date = kwargs.get("date", None)
        if date:
            kwargs_new = kwargs.copy()
            del kwargs_new["date"]
            previous_model = self.model.objects.filter(**kwargs_new).last()

        obj, created = super().get_or_create(**kwargs)
        if created and previous_model:
            obj.average = previous_model.average
            obj.data_points = previous_model.data_points
            obj.save()

        return obj, created


class RealmAccess(BaseModel):
    name = models.CharField(max_length=100)


class Actor(models.Model):
    realm_access = models.ManyToManyField(
        RealmAccess,
        through="ActorRealmAccess",
        related_name="actors",
    )


class ActorRealmAccess(BaseModel):
    actor = models.ForeignKey(
        Actor,
        related_name="actor_realm_access",
        on_delete=models.CASCADE,
    )
    realm_access = models.ForeignKey(
        RealmAccess,
        related_name="actor_realm_access",
        on_delete=models.CASCADE,
    )


class AnExtraModel(BaseModel):
    date = models.DateField()
    average = models.DecimalField(max_digits=16, decimal_places=8, default=0)
    data_points = models.IntegerField(default=0)

    objects = AnExtraModelManager.as_manager()

    class Meta:
        abstract = True
        ordering = ("date",)


class ThingManager(BaseQuerySet):

    def filter_by_realm_access_broken(self, actor):
        realm_access = RealmAccess.objects.filter(actors=actor)
        queryset = self.annotate(Count("actor__realm_access"))
        import sqlparse
        print(sqlparse.format(str(queryset.filter(
            Q(
                actor__realm_access__in=realm_access
            )
            | Q(actor__realm_access__count=0)
        ).query), reindent=True, keyword_case='upper'))
        return queryset.filter(
            Q(
                actor__realm_access__in=realm_access
            )
            | Q(actor__realm_access__count=0)
        )

    # def filter_by_realm_access_not_broken(self, actor):
    #     realm_access = RealmAccess.objects.filter(actors=actor)
    #     queryset = self.annotate(Count("actor__realm_access"))
    #     weird = queryset.filter(
    #         Q(
    #             actor__realm_access__in=realm_access
    #         )
    #         | Q(actor__realm_access__count=0)
    #     )
    #     print(weird.query)
    #     return weird.distinct()
    #
    # def filter_by_realm_access_working(self, actor):
    #     realm_access = RealmAccess.objects.filter(actors=actor)
    #     queryset = self.annotate(Count("actor__realm_access"))
    #     working = queryset.filter(
    #         Q(
    #             actor__realm_access__id__in=realm_access.values_list('id', flat=True)
    #         )
    #         | Q(actor__realm_access__count=0)
    #     )
    #     print(working.query)
    #     return working.distinct()

class Thing(AnExtraModel):
    actor = models.ForeignKey("Actor", related_name='thing_actor', on_delete=models.CASCADE)
    realms = ArrayField(models.IntegerField(), default=list)

    objects = ThingManager.as_manager()

    class Meta:
        unique_together = ("realms", "actor", "date")

