__test__ = {'BRIAN_PATCH_TESTS': """

>>> from django.core.validators import *
>>> v = AllValidators([isLowerCase, isAlphaNumeric, isNotEmpty])

>>> v('abc', '')

>>> v('abC', '')
Traceback (most recent call last):
  File "<console>", line 1, in ?
  File "django/core/validators.py", line 522, in __call__
ValidationError: ['This field is invalid.']

>>> v('a.c')
Traceback (most recent call last):
  File "<console>", line 1, in ?
TypeError: __call__() takes exactly 3 arguments (2 given)

>>> v('a c', '')
Traceback (most recent call last):
  File "<console>", line 1, in ?
  File "django/core/validators.py", line 522, in __call__
ValidationError: ['This field is invalid.']

>>> v('', '')
Traceback (most recent call last):
  File "<console>", line 1, in ?
  File "django/core/validators.py", line 522, in __call__
ValidationError: ['This field is invalid.']


>>> v = RequiredIfAllOtherFieldsNotGiven(['email', 'name'])

>>> v('', {'email': '', 'name': ''})
Traceback (most recent call last):
  File "<console>", line 1, in ?
  File "django/core/validators.py", line 499, in __call__
ValidationError: ['This field must be given if email and name are not given.']

>>> v('22', {'email': '', 'name': ''})

>>> v('22', {'email': 'test@example.com', 'name': ''})

>>> v('', {'email': 'test@example.com', 'name': ''})


>>> v = RequiredIfOtherFieldsNotGiven(['email', 'name'])

>>> v('', {'email': 'test@example.com', 'name': 'Brian'})

>>> v('22', {'email': '', 'name': ''})

>>> v('22', {'email': 'test@example.com', 'name': ''})

>>> v('', {'email': '', 'name': ''})
Traceback (most recent call last):
  File "<console>", line 1, in ?
  File "django/core/validators.py", line 522, in __call__
ValidationError: ['This field must be given if email or name are not given.']

>>> v('', {'email': 'test@example.com', 'name': ''})
Traceback (most recent call last):
  File "<console>", line 1, in ?
  File "django/core/validators.py", line 522, in __call__
ValidationError: ['This field must be given if email or name are not given.']

"""}