from django.db import models

# Create your models here.

class Foo(models.Model):
    hoge = models.IntegerField(unique = True)
    piyo = models.IntegerField(default = 0)

def get_default_foo():
    foo, created = Foo.objects.get_or_create(
        hoge = 0
    );
    return foo.id

class Bar(models.Model):
    #foo = models.ForeignKey(Foo, on_delete = models.SET_NULL, null = True)
    foo = models.ForeignKey(Foo, on_delete = models.SET_DEFAULT, default = get_default_foo)

