from django.conf import settings

"""
    Util file for custom decorators
"""


# Override django.conf settings for the duration of the function, then revert to original settings
def settings_override(**setting_kwargs):
    def wrapper(fn):
        def __inner(*args,**kwargs):
            original_values = {}
            for kwd in setting_kwargs:
                original_values[kwd] = getattr(settings,kwd,None)
                setattr(settings,kwd,setting_kwargs[kwd])
            result = fn(*args,**kwargs)
            for kwd in original_values:
                setattr(settings,kwd,original_values[kwd])
            return result
        return __inner
    return wrapper
