from django.db import models


class Model1(models.Model):
    id = models.IntegerField(primary_key=True)
    name = models.CharField(max_length=255, unique=True)


class Model2(models.Model):
    id = models.IntegerField(primary_key=True)
    link_id = models.CharField(max_length=255)
    settings = models.ForeignKey(Model1, on_delete=models.CASCADE)


class Model3(models.Model):
    id = models.IntegerField(primary_key=True)
    order = models.IntegerField()
    model_2 = models.ForeignKey(Model2, on_delete=models.CASCADE)
    direct = models.BooleanField(default=True)

    class Meta:
        unique_together = [
            ('model_2', 'order', 'direct')
            # ('model_2', 'order')
        ]
