from django.http import HttpResponse

from django.db import models
from django.contrib.postgres.aggregates import StringAgg
from .models import Product, ProductAttribute


def bug_reproduce(request):
    product = Product.objects.create(name="product")
    attrib = ProductAttribute.objects.create(product=product, attrib="attrib")

    qs = Product.objects.all()

    qs = qs.annotate(
        filtered_attribute=models.FilteredRelation(
            relation_name="attributes",
        ),
        concatenated_values=models.Case(
            models.When(
                models.Q(filtered_attribute=None),
                then=models.Value(""),
            ),
            default=StringAgg(
                models.F("name"),
                delimiter=",",
            ),
            output_field=models.CharField(),
        ),
    )

    return HttpResponse(qs)
