from django.db import models


class Product(models.Model):
    name = models.CharField(max_length=250)


class ProductAttribute(models.Model):
    """Associate a product type attribute and selected values to a given product."""

    product = models.ForeignKey(
        Product, related_name="attributes", on_delete=models.CASCADE
    )
    attrib = models.CharField(max_length=32)
