from django.db import models


# Create your models here.
class Country(models.Model):
    """A country"""
    name = models.CharField(max_length=255, verbose_name="Country name")

    def __str__(self):
        return self.name


class People(models.Model):
    """A person"""
    name = models.CharField(max_length=255, verbose_name="People name")
    country = models.ForeignKey(Country, on_delete=models.CASCADE, related_name="inhabitants",
                                verbose_name="Country")

    def __str__(self):
        return self.name