from django.contrib import admin
# Register your models here.
from django.urls import reverse
from django.utils.safestring import mark_safe

from example.models import Country, People


class CountryAdmin(admin.ModelAdmin):
    """Display country list and number of people living in"""

    list_display = ['name', 'show_inhabitants_link_id_exact', 'show_inhabitants_link_id',
                    'show_inhabitants_link_pk']

    def show_inhabitants_link_id_exact(self, instance):
        """Link with search param country__id__exact=xxx """
        url = '<a href="{baseurl}?country__id__exact={country}">Show inhabitants</a>'
        link = url.format(
            baseurl=reverse('admin:example_people_changelist'),
            country=instance.pk)
        return mark_safe(link)

    def show_inhabitants_link_id(self, instance):
        """Link with search param country__id=xxx """
        url = '<a href="{baseurl}?country__id={country}">Show inhabitants</a>'
        link = url.format(
            baseurl=reverse('admin:example_people_changelist'),
            country=instance.pk)
        return mark_safe(link)

    def show_inhabitants_link_pk(self, instance):
        """Link with search param country__pk=xxx """
        url = '<a href="{baseurl}?country__pk={country}">Show inhabitants</a>'
        link = url.format(
            baseurl=reverse('admin:example_people_changelist'),
            country=instance.pk)
        return mark_safe(link)


admin.site.register(Country, CountryAdmin)


class PeopleAdmin(admin.ModelAdmin):
    list_filter = ['country']


admin.site.register(People, PeopleAdmin)
