from django.test import SimpleTestCase
from django.utils.translation import activate, gettext as _

class TestTranslations(SimpleTestCase):

    def test_region_translations(self):
        country_people_nicknames = {
            'en_AU': 'aussie',
            'en_NZ': 'kiwi',
            'en_CA': 'canuck',
            'en': 'local country person',
        }
        for language, nick in country_people_nicknames.items():
            with self.subTest(language=language):
                activate(language)
                self.assertEqual(_('local country person'), nick)

