import os
import pycurl
from io import BytesIO


def config_pycurl(url, file_handle, file_size, response_buffer):
    # Create the curl object, set the URL and HTTP method
    c = pycurl.Curl()
    c.setopt(pycurl.VERBOSE, True)
    c.setopt(pycurl.URL, url)
    c.setopt(pycurl.POST, 1)

    # Give curl a buffer to write the remote server's response to
    c.setopt(pycurl.WRITEDATA, response_buffer)

    c.setopt(pycurl.SSL_VERIFYPEER, 0)
    c.setopt(pycurl.SSL_VERIFYHOST, 0)

    c.setopt(pycurl.POSTFIELDSIZE, file_size)
    c.setopt(pycurl.READFUNCTION, file_handle.read)
    return c


def send_pycurl(url, file_path, file_size):
    resp_buffer = BytesIO()

    input_file = open(file_path, 'rb')
    c = config_pycurl(url, input_file, file_size, resp_buffer)
    c.perform()

    # Get HTTP response code, clean up handles
    resp_code = c.getinfo(c.RESPONSE_CODE)
    c.close()
    input_file.close()

    # Get response from the server - iso-8859-1 is the default encoding curl performs
    resp_body = resp_buffer.getvalue().decode('iso-8859-1')
    print(f'code: {resp_code}')
    print(f'response: {resp_body}')


if __name__ == '__main__':
    post_url = 'http://localhost:8000/upload'
    name = 'test_files/ascii1gb.txt'
    send_pycurl(post_url, name, os.path.getsize(name))
