from django import forms
from django.contrib import admin
from django.contrib.admin.widgets import FilteredSelectMultiple

from .models import Spam

class SpamForm(forms.ModelForm):

    class Meta:
        model = Spam
        fields = forms.ALL_FIELDS

    numbers = forms.MultipleChoiceField(
        choices=[(str(i), i) for i in range(30)],
        widget=FilteredSelectMultiple('numbers', False,
                                      attrs={
                                          'rows': '10',
                                          'style': 'overflow-y:scroll',
                                      }
        )
    )

@admin.register(Spam)
class SpamAdmin(admin.ModelAdmin):
    form = SpamForm
