import asyncio
from random import random

from asgiref.sync import async_to_sync
from django.conf import settings
from django.contrib.auth.models import User
from django.db import models

# Create your models here.
from django.db.models.signals import post_save
from django.dispatch import receiver


class UserProxy(models.Model):
    user = models.OneToOneField(User, on_delete=models.CASCADE)
    discord = models.BigIntegerField(null=True)

    @async_to_sync
    async def test_async(self):
        #client = settings.DISCORD_CLIENT
        #await settings.DISCORD_CLIENT.login(settings.DISCORD['DISCORD_BOT_TOKEN'])
        num = random()
        await asyncio.sleep(0.5)
        #await client.close()
        return num


@receiver(post_save, sender=User)
def create_user_profile(sender, instance, created, **kwargs):
    if created:
        UserProxy.objects.create(user=instance)


@receiver(post_save, sender=User)
def save_user_profile(sender, instance, **kwargs):
    instance.userproxy.save()
