**Xiang Wang @ 2020-04-22 22:29:35**


I met a problem when I convert a `unique_together` to the `unique=True` attribute.

1. first commit, everything is ok
    * I create a [model file](https://github.com/ramwin/testunique/blob/665a65ddb97c5a9652b4fd5801f797123e956318/testapp/models.py).
    ```
    // testapp/models.py
    class MyModel(models.Model):
        name = models.CharField(max_length=32)
        class Meta:
            unique_together = ("name", )
    ```
    * the migrations file looks like [this](https://github.com/ramwin/testunique/blob/665a65ddb97c5a9652b4fd5801f797123e956318/testapp/migrations/0001_initial.py).
    ```
    // testapp/migrations/0001_initial.py
    # Generated by Django 3.0.5 on 2020-04-22 12:47
    from django.db import migrations, models
    class Migration(migrations.Migration):
        dependencies = [
            ('testapp', '0001_initial'),
        ]
        operations = [
            migrations.AlterField(
                model_name='mymodel',
                name='name',
                field=models.CharField(max_length=32, unique=True),
            ),
            migrations.AlterUniqueTogether(
                name='mymodel',
                unique_together=set(),
            ),
        ]
    ```
2. second commit: then I remove the `unique_together` and add `unique=True` to the field `MyModel.name`
    * [model file](https://github.com/ramwin/testunique/blob/master/testapp/models.py)
    ```
    class MyModel(models.Model):
        name = models.CharField(max_length=32, unique=True)
        class Meta:
           pass
           # unique_together = ("name", )
    ```
    * [0002 migrations file](https://github.com/ramwin/testunique/blob/master/testapp/migrations/0002_auto_20200422_1247.py)
    ```
    class Migration(migrations.Migration):
        dependencies = [
            ('testapp', '0001_initial'),
        ]
        operations = [
            migrations.AlterField(
                model_name='mymodel',
                name='name',
                field=models.CharField(max_length=32, unique=True),
            ),
            migrations.AlterUniqueTogether(
                name='mymodel',
                unique_together=set(),
            ),
        ]
    ```

However, when I apply the migrations, an error occurs;
```
wangx@aliyun:~/testunique$ python3 manage.py migrate
Operations to perform:
  Apply all migrations: admin, auth, contenttypes, sessions, testapp
Running migrations:
  Applying contenttypes.0001_initial... OK
  Applying auth.0001_initial... OK
  Applying admin.0001_initial... OK
  Applying admin.0002_logentry_remove_auto_add... OK
  Applying admin.0003_logentry_add_action_flag_choices... OK
  Applying contenttypes.0002_remove_content_type_name... OK
  Applying auth.0002_alter_permission_name_max_length... OK
  Applying auth.0003_alter_user_email_max_length... OK
  Applying auth.0004_alter_user_username_opts... OK
  Applying auth.0005_alter_user_last_login_null... OK
  Applying auth.0006_require_contenttypes_0002... OK
  Applying auth.0007_alter_validators_add_error_messages... OK
  Applying auth.0008_alter_user_username_max_length... OK
  Applying auth.0009_alter_user_last_name_max_length... OK
  Applying auth.0010_alter_group_name_max_length... OK
  Applying auth.0011_update_proxy_permissions... OK
  Applying sessions.0001_initial... OK
  Applying testapp.0001_initial... OK
  Applying testapp.0002_auto_20200422_1247...Traceback (most recent call last):
  File "/usr/local/lib/python3.6/dist-packages/django/db/backends/utils.py", line 86, in _execute
    return self.cursor.execute(sql, params)
  File "/usr/local/lib/python3.6/dist-packages/django/db/backends/mysql/base.py", line 74, in execute
    return self.cursor.execute(query, args)
  File "/usr/local/lib/python3.6/dist-packages/MySQLdb/cursors.py", line 209, in execute
    res = self._query(query)
  File "/usr/local/lib/python3.6/dist-packages/MySQLdb/cursors.py", line 315, in _query
    db.query(q)
  File "/usr/local/lib/python3.6/dist-packages/MySQLdb/connections.py", line 239, in query
    _mysql.connection.query(self, query)
MySQLdb._exceptions.OperationalError: (1061, "Duplicate key name 'testapp_mymodel_name_ba5e2bd2_uniq'")

The above exception was the direct cause of the following exception:

Traceback (most recent call last):
  File "manage.py", line 21, in <module>
    main()
  File "manage.py", line 17, in main
    execute_from_command_line(sys.argv)
  File "/usr/local/lib/python3.6/dist-packages/django/core/management/__init__.py", line 401, in execute_from_command_line
    utility.execute()
  File "/usr/local/lib/python3.6/dist-packages/django/core/management/__init__.py", line 395, in execute
    self.fetch_command(subcommand).run_from_argv(self.argv)
  File "/usr/local/lib/python3.6/dist-packages/django/core/management/base.py", line 328, in run_from_argv
    self.execute(*args, **cmd_options)
  File "/usr/local/lib/python3.6/dist-packages/django/core/management/base.py", line 369, in execute
    output = self.handle(*args, **options)
  File "/usr/local/lib/python3.6/dist-packages/django/core/management/base.py", line 83, in wrapped
    res = handle_func(*args, **kwargs)
  File "/usr/local/lib/python3.6/dist-packages/django/core/management/commands/migrate.py", line 233, in handle
    fake_initial=fake_initial,
  File "/usr/local/lib/python3.6/dist-packages/django/db/migrations/executor.py", line 117, in migrate
    state = self._migrate_all_forwards(state, plan, full_plan, fake=fake, fake_initial=fake_initial)
  File "/usr/local/lib/python3.6/dist-packages/django/db/migrations/executor.py", line 147, in _migrate_all_forwards
    state = self.apply_migration(state, migration, fake=fake, fake_initial=fake_initial)
  File "/usr/local/lib/python3.6/dist-packages/django/db/migrations/executor.py", line 245, in apply_migration
    state = migration.apply(state, schema_editor)
  File "/usr/local/lib/python3.6/dist-packages/django/db/migrations/migration.py", line 124, in apply
    operation.database_forwards(self.app_label, schema_editor, old_state, project_state)
  File "/usr/local/lib/python3.6/dist-packages/django/db/migrations/operations/fields.py", line 249, in database_forwards
    schema_editor.alter_field(from_model, from_field, to_field)
  File "/usr/local/lib/python3.6/dist-packages/django/db/backends/base/schema.py", line 565, in alter_field
    old_db_params, new_db_params, strict)
  File "/usr/local/lib/python3.6/dist-packages/django/db/backends/base/schema.py", line 745, in _alter_field
    self.execute(self._create_unique_sql(model, [new_field.column]))
  File "/usr/local/lib/python3.6/dist-packages/django/db/backends/base/schema.py", line 142, in execute
    cursor.execute(sql, params)
  File "/usr/local/lib/python3.6/dist-packages/django/db/backends/utils.py", line 100, in execute
    return super().execute(sql, params)
  File "/usr/local/lib/python3.6/dist-packages/django/db/backends/utils.py", line 68, in execute
    return self._execute_with_wrappers(sql, params, many=False, executor=self._execute)
  File "/usr/local/lib/python3.6/dist-packages/django/db/backends/utils.py", line 77, in _execute_with_wrappers
    return executor(sql, params, many, context)
  File "/usr/local/lib/python3.6/dist-packages/django/db/backends/utils.py", line 86, in _execute
    return self.cursor.execute(sql, params)
  File "/usr/local/lib/python3.6/dist-packages/django/db/utils.py", line 90, in __exit__
    raise dj_exc_value.with_traceback(traceback) from exc_value
  File "/usr/local/lib/python3.6/dist-packages/django/db/backends/utils.py", line 86, in _execute
    return self.cursor.execute(sql, params)
  File "/usr/local/lib/python3.6/dist-packages/django/db/backends/mysql/base.py", line 74, in execute
    return self.cursor.execute(query, args)
  File "/usr/local/lib/python3.6/dist-packages/MySQLdb/cursors.py", line 209, in execute
    res = self._query(query)
  File "/usr/local/lib/python3.6/dist-packages/MySQLdb/cursors.py", line 315, in _query
    db.query(q)
  File "/usr/local/lib/python3.6/dist-packages/MySQLdb/connections.py", line 239, in query
    _mysql.connection.query(self, query)
django.db.utils.OperationalError: (1061, "Duplicate key name 'testapp_mymodel_name_ba5e2bd2_uniq'")
```

I check the sql for these migrations, it shows:
```
wangx@aliyun:~/testunique$ python3 manage.py sqlmigrate testapp 0001
--
-- Create model MyModel
--
CREATE TABLE `testapp_mymodel` (`id` integer AUTO_INCREMENT NOT NULL PRIMARY KEY, `name` varchar(32) NOT NULL);
ALTER TABLE `testapp_mymodel` ADD CONSTRAINT `testapp_mymodel_name_ba5e2bd2_uniq` UNIQUE (`name`);
wangx@aliyun:~/testunique$ python3 manage.py sqlmigrate testapp 0002
--
-- Alter field name on mymodel
--
ALTER TABLE `testapp_mymodel` ADD CONSTRAINT `testapp_mymodel_name_ba5e2bd2_uniq` UNIQUE (`name`);
--
-- Alter unique_together for mymodel (0 constraint(s))
--
ALTER TABLE `testapp_mymodel` DROP INDEX `testapp_mymodel_name_ba5e2bd2_uniq`;
```

it looks like django will
1. first create the index for `unique=True`
2. drop the index for `unique_together=('name', )`

but the program for creating index name **generates the same index** name :`testapp_mymodel_name_ba5e2bd2_uniq`, so when django create the same index, Duplicate key name error occurs.
