from django.db import models


class Book(models.Model):
    name = models.CharField(max_length=32)
    rating = models.IntegerField(default=0)


class FavoriteBook(models.Model):
    book = models.ForeignKey(Book, on_delete=models.CASCADE)


class Label(models.Model):
    name = models.CharField(max_length=32)


class Review(models.Model):
    book = models.ForeignKey(Book, on_delete=models.CASCADE, related_name="reviews")
    text = models.TextField()
    labels = models.ManyToManyField(Label)

