var SelectBox = {
   cache: new Object(),
   init: function(id) {
       var box = document.getElementById(id);
       var node;
       SelectBox.cache[id] = new Object();
       var boxCache = SelectBox.cache[id];
       for (var i = 0; (node = box.options[i]); i++) {
           boxCache[ node.value ] = { value: node.value, text: node.text, displayed: 1 };
       }
   },
   redisplay: function(id) {
       // Repopulate HTML select box from cache
       var box = document.getElementById(id);
       box.options.length = 0; // clear all options
              var elementsArray = SelectBox.sort(id);
              for( var i=0; i<elementsArray.length; i++ ) {
           var node = elementsArray[i]; //SelectBox.cache[id][nodeValue];

           if (node.displayed) {
               box.options[box.options.length] = new Option(node.text, node.value, false, false);
           }
       }
   },
   filter: function(id, text) {
       // Redisplay the HTML select box, displaying only the choices containing ALL
       // the words in text. (It's an AND search.)
       var tokens = text.toLowerCase().split(/\s+/);
       var node, token;
       for (var nodeValue in SelectBox.cache[id]) {
           node = SelectBox.cache[id][nodeValue];
           node.displayed = 1;
           for (var j = 0; (token = tokens[j]); j++) {
               if (node.text.toLowerCase().indexOf(token) == -1) {
                   node.displayed = 0;
               }
           }
       }
       SelectBox.redisplay(id);
   },
   delete_from_cache: function(id, value) {
       delete SelectBox.cache[id][value];
   },
   add_to_cache: function(id, option) {
       SelectBox.cache[id][ option.value ] = { value: option.value, text: option.text, displayed: 1 };
   },
   cache_contains: function(id, value) {
       return SelectBox.cache[id].hasOwnProperty(value);
   },
   move: function(from, to) {
       var from_box = document.getElementById(from);
       var to_box = document.getElementById(to);
       var option;
       for (var i = 0; (option = from_box.options[i]); i++) {
           if (option.selected && SelectBox.cache_contains(from, option.value)) {
               SelectBox.add_to_cache(to, { value: option.value, text: option.text, displayed: 1 });
               SelectBox.delete_from_cache(from, option.value);
           }
       }
       SelectBox.redisplay(from);
       SelectBox.redisplay(to);
   },
   move_all: function(from, to) {
       var from_box = document.getElementById(from);
       var to_box = document.getElementById(to);
       var option;
       for (var i = 0; (option = from_box.options[i]); i++) {
           SelectBox.add_to_cache(to, { value: option.value, text: option.text, displayed: 1 });
           SelectBox.delete_from_cache(from, option.value);
       }
       SelectBox.redisplay(from);
       SelectBox.redisplay(to);
   },
   sort: function(id) {

       var cache = SelectBox.cache[id];
       var array = new Array();
              for( optionValue in cache ) {
                  var option = cache[optionValue];
           array.push(option);
       }
              array.sort( function(a, b) {
           a = a.text.toLowerCase();
           b = b.text.toLowerCase();
           try {
               if (a > b) return 1;
               if (a < b) return -1;
           }
           catch (e) {
               // silently fail on IE 'unknown' exception
           }
           return 0;
       } );
              return array;
   },
   select_all: function(id) {
       var box = document.getElementById(id);
       for (var i = 0; i < box.options.length; i++) {
           box.options[i].selected = 'selected';
       }
   }
}
