# single-file django via https://github.com/readevalprint/mini-django/blob/master/pico_django.py
# run with django dev server:
# $ pip install Django
# $ PYTHONPATH=. django-admin.py runserver 0.0.0.0:8000 --settings=converter_test


import random
from django.http import HttpResponse
from django.urls import path, register_converter, reverse
from django.urls.converters import IntConverter


## settings

DEBUG = True
ROOT_URLCONF = 'converter_test'
ALLOWED_HOSTS = '*'
DATABASES = {'default': {}}
SECRET_KEY = "not so secret"


## views

def index(request):
    # simulate a generic "export thing" template that might be asked to link to a Foo or a Bar:
    some_foo_or_bar = Foo(1) if random.randint(0, 1) else Bar(1)
    return HttpResponse("Export your %s: %s" % (some_foo_or_bar, reverse('export', args=[some_foo_or_bar])))


## url converters

# in reality these might be two different Django models
class Foo(int): pass
class Bar(int): pass

class FooConverter(IntConverter):
    def to_python(self, value):
        return Foo(value)

    def to_url(self, obj):
        if type(obj) is not Foo:
            # returning '' will cause the route not to match, but returning ValueError would be more consistent
            return ''
        return super().to_url(obj)

class BarConverter(IntConverter):
    def to_python(self, value):
        return Bar(value)

    def to_url(self, obj):
        if type(obj) is not Bar:
            # returning '' will cause the route not to match, but returning ValueError would be more consistent
            return ''
        return super().to_url(obj)

register_converter(FooConverter, 'foo')
register_converter(BarConverter, 'bar')


## urls

urlpatterns = [
    path('', index),
    path('export/foo/<foo:obj>', index, name='export'),
    path('export/bar/<bar:obj>', index, name='export'),
]
