from django.contrib.admindocs.utils import replace_named_groups

path_regex = r'entries/(?P<pk>[^/.]+)/relationships/(?P<related_field>\w+)'
expected_path = 'entries/<pk>/relationships/<related_field>'
path_regex_trailing = path_regex + '/'
expected_path_trailing = expected_path + '/'

path_trailing = replace_named_groups(path_regex_trailing)
path = replace_named_groups(path_regex)

print('         path:', path_regex)
print('     expected:', expected_path)
print('          got:', path)
print()
print('path_trailing:', path_regex_trailing)
print('     expected:', expected_path_trailing)
print('          got:', path_trailing)

assert path_trailing == expected_path_trailing, "path with trailing slash didn't match expected"

assert path == expected_path, "path without trailing slash didn't match expected"

