from django.db import models
from catalog.models import Book


class Links(models.Model):
    urls = models.CharField(max_length=800, help_text='The url from where the book is provided')
    last_updated = models.DateTimeField(auto_now=True)
    book = models.OneToOneField(Book, on_delete=models.CASCADE)

    def __str__(self):
        return str(self.book)

    class Meta:
        verbose_name = 'Link'
        permissions = [
            ("can_fetch_link", "Can fetch link"),
            ("can_view_link", "Can view link"),
        ]
