import uuid

from django.db import models
from django.utils.translation import ugettext_lazy as _, ungettext

import testapp2.models

class App1(models.Model):
    id = models.UUIDField(primary_key=True, unique=True, default=uuid.uuid4, editable=False, verbose_name=_('identifier'))
    text = models.CharField(max_length=100, verbose_name=_('text'))
    # another_app = models.UUIDField(null=True, blank=True, verbose_name=_('another app'))
    another_app = models.ForeignKey(testapp2.models.App2, null=True, blank=True, on_delete=models.SET_NULL, verbose_name=_('another app'))