from django.db import models

# Create your models here.


class Company(models.Model):
    name = models.CharField(max_length=100)

    def __str__(self):
        return self.name

    class Meta:
        verbose_name = "company"
        verbose_name_plural = "companies"


class Twitter(models.Model):
    username = models.CharField(
        primary_key=True,
        max_length=128
    )
    company = models.ForeignKey(
        Company,
        related_name="twitters",
        on_delete=models.CASCADE
    )

    def __str__(self):
        return self.username

    class Meta:
        verbose_name = "twitter"


class TweetCse(models.Model):
    tw_su = models.ForeignKey(
        Twitter,
        related_name="cse_su",
        on_delete=models.CASCADE,
        verbose_name="corporate twitter"
    )
    tw_corpo = models.ForeignKey(
        Twitter,
        related_name="cse_corpo",
        on_delete=models.CASCADE,
        verbose_name="startup twitter"
    )
    valid = models.NullBooleanField(blank=True)
    target = models.NullBooleanField(blank=True)

    def __str__(self):
        return f"{self.tw_corpo_id} => {self.tw_su_id}"

    class Meta:
        verbose_name = "corporate-startup relationship"
