from django.contrib import admin
from foo.models import Book, Author


@admin.register(Author)
class AuthorAdmin(admin.ModelAdmin):
    ordering = ['name']


@admin.register(Book)
class BookAdmin(admin.ModelAdmin):
    list_filter = (
        ('author', admin.RelatedFieldListFilter),
        ('author', admin.RelatedOnlyFieldListFilter),
    )