from django.contrib import admin

from .models import *

class ReportPhotoInlineModelAdmin(admin.TabularInline):
    model = Report.photos.through
    show_change_link = True

class ReportAdmin(admin.ModelAdmin):
    inlines = [ReportPhotoInlineModelAdmin]
    exclude = ['photos',]

admin.site.register(Report, ReportAdmin)
admin.site.register(Photo, admin.ModelAdmin)
