from django.contrib.auth.models import User

from django.db.models import Subquery, Q, Sum, When, IntegerField, OuterRef, Case, Value
from django.db.models.functions import Coalesce
from django.test import TestCase

from .models import Recipe, IngredientDetail, RecipeIngredient

class Test(TestCase):
    def test(self):
        recipes = Recipe.objects.all()
        user = User.objects.create(username='foo')

        annotations = {}
        annotations['cost_value'] = Subquery(
            IngredientDetail.objects.filter(Q(ingredient_id=OuterRef('ingredient_id')) & Q(user=user)).values('cost')[:1]
        )
        ingredients = RecipeIngredient.objects.filter(recipe__in=recipes).annotate(**annotations)
        aggregators = {}
        aggregators['cost_missing'] = Coalesce(Sum(
            Case(
               When(**{'cost_value': None}, then=Value(1)),
               default=Value(0),
               output_field=IntegerField()
           )
        ), Value(0))
        print(ingredients.aggregate(**aggregators))
