"""minimal_example URL Configuration

The `urlpatterns` list routes URLs to views. For more information please see:
    https://docs.djangoproject.com/en/2.1/topics/http/urls/
Examples:
Function views
    1. Add an import:  from my_app import views
    2. Add a URL to urlpatterns:  path('', views.home, name='home')
Class-based views
    1. Add an import:  from other_app.views import Home
    2. Add a URL to urlpatterns:  path('', Home.as_view(), name='home')
Including another URLconf
    1. Import the include() function: from django.urls import include, path
    2. Add a URL to urlpatterns:  path('blog/', include('blog.urls'))
"""
from django.contrib import admin
from django.urls import path

from django.conf.urls.i18n import i18n_patterns
from django.utils.translation import gettext_lazy as _

#customize auth views
from django.contrib.auth import views as auth_views

urlpatterns = []

urlpatterns += i18n_patterns(    
    # accounts (django.contrib.auth.urls)
    # email + pw
    path('accounts/login/', auth_views.LoginView.as_view(redirect_authenticated_user=True), name='login'),
    # ciao
    path('accounts/logout/', auth_views.LogoutView.as_view(), name='logout'),
    #pw_old -> pw_new
    path('accounts/password_change/', auth_views.PasswordChangeView.as_view(), name='password_change'),
    #successful change
    path('accounts/password_change/done/', auth_views.PasswordChangeDoneView.as_view(), name='password_change_done'),
    #forgot your pw?
    path('accounts/password_reset/', auth_views.PasswordResetView.as_view(), name='password_reset'),
    #we sent you a link (should only be visible as redirect)
    path('accounts/password_reset/done/', auth_views.PasswordResetDoneView.as_view(), name='password_reset_done'),
    #clicking link
    path('accounts/reset/<uidb64>/<token>/', auth_views.PasswordResetConfirmView.as_view(), name='password_reset_confirm'),
    #successful reset
    path('accounts/reset/done/', auth_views.PasswordResetCompleteView.as_view(), name='password_reset_complete'),
    prefix_default_language=False,
)