from django.contrib import admin

from . import models


class InlineOnline(admin.StackedInline):
    model = models.Inline
    extra = 1


@admin.register(models.One)
class OneAdmin(admin.ModelAdmin):
    fieldsets = (
        (None, {
            "fields": (
                'title',
                'twos',
            ),
        }),
    )

    inlines = (
        InlineOnline,
    )

    filter_horizontal = [
        'twos',
    ]
